#ifndef f_DISKIO_H
#define f_DISKIO_H

void kf_read(RawDisk& raw_disk, int trackcount, int trackstep, const char *basepath, int countpos, int countwidth, int trackselect);
void scp_read(RawDisk& raw_disk, const char *path, int selected_track);
void scp_write(const RawDisk& raw_disk, const char *path, int selected_track);

void scp_direct_read(RawDisk& raw_disk, const char *path, int selected_track);
void scp_direct_write(const RawDisk& raw_disk, const char *path, int selected_track);

void read_atr(DiskInfo& disk, const char *path, int track_select);
void read_atx(DiskInfo& disk, const char *path, int track);
void write_atx(const char *path, DiskInfo& disk, int track);
void write_atr(const char *path, DiskInfo& disk, int track);

void write_apple2_dsk(const char *path, DiskInfo& disk, int track);
void write_apple2_nib(const char *path, const DiskInfo& disk, int track);

#endif
